/****************************************************************************
 **                                                                        **
 **  Various bitmap functions - Aron, 1998.                                **
 **                                                                        **
 ****************************************************************************/

// - szabvany fejlecfile-ok -------------------------------------------------
#include <math.h>

// - sajat fejlecfile-ok ----------------------------------------------------
#include "defs.h"
#include "bitmap.h"
#include "tinymath.h"
#include "tracer.h"
#include "font.h"

// - implementacio ----------------------------------------------------------
byte shadetable[256*256],motionblurtable[256*256],Phongmap[256*256];;

// - tabla prekalkulalo -----------------------------------------------------
void InitTables(void)
{ signed int i,j;
  float light;

  // altalanos tablazatok:
  for(i=0; i<256; i++) for(j=0; j<256; j++)
  { // shade tabla:
    *(shadetable + 256*i + j)= i*(j/255.0);
    // motion blur tabla:
    *(motionblurtable + 256*i + j)= (byte)((i + j)>>1);
    // Phong tabla sin-osan befele novekvo intenzitassal:
    light= 80.0*(1.0 - fsin(1.5*M_PI + fsqrt(fsqr(i - 128.0) + fsqr(j - 128.0))*M_PI/2.0/80.0));
    *(Phongmap + (256*i + j))= (byte)light;
  }
}

// - sztring rajzolo --------------------------------------------------------
void DrawString_ASM(char *string,byte *destptr,PROPORTIONAL_CHAR *fontptr,dword X,dword Y,dword intensity);
#pragma aux DrawString_ASM "_*" modify [eax ebx ecx edx esi edi] parm [ebx] [edi] [esi] [ecx] [edx] [eax]

void DrawString(char *string,byte *destptr,dword X,dword Y,dword intensity)
{ DrawString_ASM(string,destptr,&letter[0],X,Y,intensity);
}

// - wormhole effekt --------------------------------------------------------
byte wormholetable[2*320*180];
byte distanceadder,angleadder,distanceadder2,angleadder2;

void InitWormhole(void)
{ signed int i,j,index;
  float x,y,z;

  for(j=1; j<DIVS+1; j++) for(i=0; i<SPOKES; i++)
  { // elso tablazat:
    z= 0.5 - 4.0*flog(2.0*j/DIVS);
    x= 250.0 + 500.0*j/DIVS * fcos(2.0*M_PI*i/SPOKES);
    y= 100.0 + 200.0*j/DIVS * fsin(2.0*M_PI*i/SPOKES) - z*STRETCH;

    if((x>=0) && (x<320) && (y>=0) && (y<180))
    { // index a tablazatban:
      index= 2*(320*(dword)y + (dword)x);

      // mapping koordinatak:
      wormholetable[index]= i % 256;
      wormholetable[index + 1]= j % 256;
    }
  }
}

void DrawWormHole_ASM(byte *,byte *,byte *);
#pragma aux DrawWormHole_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [eax]

void DrawWormHole(byte *destptr,byte *srcptr,byte *srcptr2,dword factor)
{ distanceadder= factor; angleadder= factor;
  distanceadder2= -factor; angleadder2= -factor;

  DrawWormHole_ASM(destptr,srcptr,srcptr2);
}

// - textura zoomer ---------------------------------------------------------
dword zoomerstart,zoomerdelta;

void DrawZoomer_ASM(byte *,byte *);
#pragma aux DrawZoomer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void DrawZoomer(byte *destptr,byte *srcptr,float delta)
{ // bal felso pont 8.8 fixpontos koordinataja:
  zoomerstart= (dword)((128.0 - delta*128.0) * 256.0);
  // 8.8 fixpontos delta:
  zoomerdelta= (dword)(delta*256.0);

  DrawZoomer_ASM(destptr,srcptr);
}

// - keretezett/nagyitott kiskep kirako -------------------------------------
void DrawMiniPicture_ASM(byte *,byte *);
#pragma aux DrawMiniPicture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void DrawMiniPicture(byte *destptr,byte *srcptr)
{ DrawMiniPicture_ASM(destptr,srcptr);
}

// - fader es crossfader ----------------------------------------------------
void FadeFrameBuffer_ASM(byte *,byte *,dword);
#pragma aux FadeFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [eax]

void FadeFrameBuffer(byte *destptr,byte fadefactor)
{ FadeFrameBuffer_ASM(destptr,shadetable,fadefactor);
}

void CrossFadeFrameBuffer_ASM(byte *,byte *,dword);
#pragma aux CrossFadeFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [eax]

void CrossFadeFrameBuffer(byte *destptr,byte *srcptr,byte fadefactor)
{ CrossFadeFrameBuffer_ASM(destptr,srcptr,fadefactor);
}

// - legyszem-effekt rajzolo ------------------------------------------------
void DrawFlyEye_ASM(byte *);
#pragma aux DrawFlyEye_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi]

void DrawFlyEye(byte *destptr)
{ DrawFlyEye_ASM(destptr);
}

// - polar blur (spin- es zoom blur) ----------------------------------------
double polarblurtable[2*320*180];
byte PBtablecalculated= FALSE;

byte GetPolarPixel(byte *destptr,double r,double theta)
{ float dX= r*fsin(theta),dY= r*fcos(theta);
  dword offset= 4*(320*(dword)(90.0 + dY) + (dword)(160.0 + dX));

  return *(destptr + offset);
}

void BlurPolarFrameBuffer(byte *destptr,byte *srcptr,dword blurtype)
{ signed int x,y;
  double distance,angle;
  byte pixel;

  for(y=20; y<160; y++) for(x=0; x<320; x++)
  { // polarkoordinatak kiolvasa a tablazatbol:
    distance= polarblurtable[2*(320*y + x)];
    angle= polarblurtable[2*(320*y + x) + 1];

    // spin blur:
    pixel= (   GetPolarPixel(srcptr,distance,angle - 0.25) +
             2*GetPolarPixel(srcptr,distance,angle - 0.125) +
             8*GetPolarPixel(srcptr,distance,angle - 0.0625) +
            16*GetPolarPixel(srcptr,distance,angle) +
             8*GetPolarPixel(srcptr,distance,angle + 0.0625) +
             2*GetPolarPixel(srcptr,distance,angle + 0.125) +
             GetPolarPixel(srcptr,distance,angle + 0.25)
           )/(16 + 2*8 + 2*2 + 2*1);

    // pixel kirakasa:
    *(destptr + 4*(320*y + x) + 0)= pixel;
    *(destptr + 4*(320*y + x) + 1)= pixel;
    *(destptr + 4*(320*y + x) + 2)= pixel;
  }
}

void InitBlurer(byte *destptr,dword blurtype)
{ dword i= 0;
  signed int x,y;
  double dX,dY;
  double angle,distance;

  if(PBtablecalculated == FALSE)
  { // polarblurtable prekalkulacioja (ha meg nem tortent meg):
    for(y=0; y<180; y++) for(x=0; x<320; x++)
    { dX= x - 160.0; dY= y - 90.0;
      // tavolsag a kepernyo kozeppontjatol:
      distance= fsqrt(0.99*dX*dX + 0.99*dY*dY);
      // szog a kepernyo kozeppontjahoz huzott vektorral:
      if(distance) angle= fpatan(dY,dX); else angle= 0;

      // tablazat kitoltese (2*i <- distance, 2*i + 1 <- angle):
      polarblurtable[i]= distance;
      polarblurtable[i + 1]= angle;

      // kovetkezo bejegyzes:
      i+= 2;
    }

    // a prekalkulacio megtortent:
    PBtablecalculated= TRUE;
  }

  for(i=0; i<(PHASES_BLURRED - 1); i++)
   BlurPolarFrameBuffer(destptr + (i + 1)*BLURBUFFER_SIZE,destptr + i*BLURBUFFER_SIZE,blurtype);
}

void DrawBlurredImage_ASM(byte *,byte *);
#pragma aux DrawBlurredImage_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void DrawBlurredImage(byte *destptr,byte *srcptr)
{ DrawBlurredImage_ASM(destptr,srcptr);
}

// - fekete-feherre konvertalo ----------------------------------------------
void ConvertMonoFrameBuffer_ASM(byte *destptr,byte *srcptr);
#pragma aux ConvertMonoFrameBuffer_ASM =                                \
        "mov ecx,57920"                                                 \
"NxtPix: lodsd"                                                         \
        "and eax,00000FF00h" /* G kimaszkolasa */                       \
        "mov al,ah" /* pixel kibovitese */                              \
        "shl eax,8"                                                     \
        "mov al,ah"                                                     \
        "dec ecx"                                                       \
        "stosd"                                                         \
        "jnz NxtPix"                                                    \
        modify [eax ecx esi edi]                                        \
        parm [edi] [esi]

void ConvertMonoFrameBuffer(byte *destptr,byte *srcptr)
{ ConvertMonoFrameBuffer_ASM(destptr,srcptr);
}

// - logo rajzolo -----------------------------------------------------------
void DrawLogo_ASM(byte *);
#pragma aux DrawLogo_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi]

void DrawLogo(byte *destptr)
{ DrawLogo_ASM(destptr);
}

// - villantas --------------------------------------------------------------
extern void BlinkFrameBuffer_ASM(byte *destptr,dword factor);
#pragma aux BlinkFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [eax]

void BlinkFrameBuffer(byte *destptr,dword factor)
{ BlinkFrameBuffer_ASM(destptr,factor);
}

// - additiv polarkoordinatas bitmapeffekt ----------------------------------
byte polartable[520*281*2];
byte distanceadder,angleadder,distanceadder2,angleadder2;
dword polaroffset2,polaroffset3;

void InitPolarizator(void)
{ signed int x,y;
  dword index= 0;
  float dX,dY,distance,angle;

  for(y=0; y<281; y++) for(x=0; x<520; x++)
  { // tavolsag a kepernyo kozeppontjatol:
    dX= x - 260; dY= y - 140;
    distance= fsqrt(dX*dX*0.8*0.8 + dY*dY);
    // szog a kepernyo kozeppontjahoz huzott vektorral:
    if(distance) angle= fpatan(dY,dX); else angle= 0;
    if(angle < 0.0) angle= -angle;

    // tablazat kitoltese (2*i <- distance, 2*i + 1 <- angle):
    polartable[index]= ((dword)distance) % 256;
    polartable[index + 1]= 128.0*angle;

    // kovetkezo bejegyzes:
    index+= 2;
  }
}

void PolarizeBitmap_ASM(byte *,dword,byte *,byte *);
#pragma aux PolarizeBitmap_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [eax] [esi] [ecx]

void PolarizeBitmap(byte *destptr,dword offset1,dword offset2,dword offset3,
                    byte *srcptr,byte dadder,byte aadder,
                    byte *srcptr2,byte dadder2,byte aadder2)
{ distanceadder= dadder; angleadder= aadder;
  distanceadder2= dadder2; angleadder2= aadder2;

  polaroffset2= offset2; polaroffset3= offset3;

  PolarizeBitmap_ASM(destptr,offset1,srcptr,srcptr2);
}

// - keptorzitas "golyoval" -------------------------------------------------
dword torsiontable[320*180*2];

void RecalcTorsionTable(signed int cX1,signed int cY1,signed int cX2,signed int cY2)
{ signed int x,y,index= 0;
  signed int dX,dY,distance1,distance2;
  signed int a,b;

  // 640x400-as kep torzitasa:
  for(y=-180; y<180; y+=2) for(x=-320; x<320; x+=2)
  { // torzitas 2 blob-bal:
    dX= x - cX1; dY= y - cY1; distance1= (dX*dX + dY*dY)>>6;
    dX= x - cX2; dY= y - cY2; distance2= (dX*dX + dY*dY)>>6;
    if(distance2 < distance1) distance1= distance2;
    // X/Y torzitas 32bites modban:
    a= ((160<<16) - x*distance1)>>16;
    b= ((90<<16) - y*distance1)>>16;
    if(a < 0) a= 0; else if(a > 319) a= 319;
    if(b < 0) b= 0; else if(b > 179) b= 179;
    torsiontable[index]= 319 - a - 50;
    torsiontable[index + 1]= 179 - b;
    // kovetkezo elem:
    index+= 2;
  }
}

void DistortBitmap_ASM(byte *,byte *);
#pragma aux DistortBitmap_ASM =                                         \
        "lea ebx,torsiontable" /* precalc tablara mutat */              \
        "mov ecx,57600" /* 320x180 pixel */                             \
"NxtPix: mov eax,dword ptr [ebx + 4]"                                   \
        "mov edx,eax"                                                   \
        "shl eax,8"                                                     \
        "shl edx,6"                                                     \
        "add eax,edx"                                                   \
        "add eax,dword ptr [ebx]" /* EAX:= dY*320 + dX */               \
        "mov dl,byte ptr [esi + eax*4 + 0]" /* pixel be */   \
        "mov dh,byte ptr [edi + 0]" /* pixel be */            \
        "mov dl,motionblurtable[edx]"                         \
        "mov byte ptr [edi + 0],dl"\
        "mov dl,byte ptr [esi + eax*4 + 1]" /* pixel be */   \
        "mov dh,byte ptr [edi + 1]" /* pixel be */            \
        "mov dl,motionblurtable[edx]"                         \
        "mov byte ptr [edi + 1],dl"\
        "mov dl,byte ptr [esi + eax*4 + 2]" /* pixel be */   \
        "mov dh,byte ptr [edi + 2]" /* pixel be */            \
        "mov dl,motionblurtable[edx]"                         \
        "mov byte ptr [edi + 2],dl"\
        "add edi,4" /* kovetkezo pixel */                               \
        "add ebx,8"           \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        modify [eax ebx ecx edx]                                        \
        parm [edi] [esi]

void DistortBitmap(byte *destptr,byte *srcptr)
{ DistortBitmap_ASM(destptr,srcptr);
}

// - keprangatas effekt -----------------------------------------------------
void TwitchFrameBuffer_ASM(byte *,byte *,dword);
#pragma aux TwitchFrameBuffer_ASM =                                     \
        "mov ecx,180"                                                   \
        "push esi" /* ESI elmentese */                                  \
        "sub ecx,edx"                                                   \
        "imul edx,1280" /* EDX:= 4*320*rows */                          \
        "imul ecx,320" /* ECX:= 320*(180 - rows) */                     \
        "add esi,edx"                                                   \
        "mov ebx,ecx" /* EBX szamolja az atmasolt pixeleket */          \
        "rep movsd" /* rows sor atugrasaval masolas */                  \
        "xor eax,eax"                                                   \
        "mov ecx,6400" /* 20*320 fekete pixel */                        \
        "add ebx,6400"                                                  \
        "rep stosd"                                                     \
        "pop esi" /* ESI vissza */                                      \
        "mov ecx,57600" /* 320*180*/                                    \
        "sub ecx,ebx" /* visszamaradt pixelek */                        \
        "rep movsd"                                                     \
        modify [eax ebx ecx edx esi edi]                                \
        parm [edi] [esi] [edx]

void TwitchFrameBuffer(byte *destptr,byte *srcptr,dword row)
{ TwitchFrameBuffer_ASM(destptr,srcptr,row + 30);
}

// - texturazott bump -------------------------------------------------------
extern void DrawBump_ASM(byte *destptr,byte *srcptr,dword adder);
#pragma aux DrawBump_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [edx]

void DrawBump(byte *desptr,byte *srcptr,dword X,dword Y)
{ DrawBump_ASM(desptr,srcptr,256*Y + X);

}

// - shaded csikok oldalra --------------------------------------------------
void DrawStripes_ASM(byte *);
#pragma aux DrawStripes_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi]

void DrawStripes(byte *destptr)
{ DrawStripes_ASM(destptr);
}

// - kockazas effekt --------------------------------------------------------
byte columns;

void DrawSquares_ASM(byte *);
#pragma aux DrawSquares_ASM =                                           \
        "add edi,720" /* 4*180 */                                       \
"NxtRow: mov edx,12"                                                    \
"NxtPix: mov eax,dword ptr [edi + 2568]" /* pixel be: 4*(2*320 + 2) */  \
        "mov ecx,8"                                                     \
"NxtDpH: push edi" /* EDI elmentese fuggoleges sokszorozas elott */     \
        "mov ebx,8"                                                     \
"NxtDpV: mov dword ptr [edi],eax"                                       \
        "add edi,1280" /* fuggoleges lepes */                           \
        "dec ebx"                                                       \
        "jnz NxtDpV"                                                    \
        "pop edi" /* EDI visszatoltese vizszintes lepeshez */           \
        "add edi,4" /* vizszintes lepes */                              \
        "dec ecx"                                                       \
        "jnz NxtDpH"                                                    \
        "dec edx" /* kovetkezo pixel */                                 \
        "jnz NxtPix"                                                    \
        "add edi,9856" /* 4*(8*320 - 8*12) */                           \
        "dec [columns]"                                                 \
        "jnz NxtRow"                                                    \
        modify [eax ebx ecx edx esi edi]                                \
        parm [edi]

void DrawSquares(byte *destptr)
{ // "kockazas":
  columns= 23;
  DrawSquares_ASM(destptr);
}

// - invertalt csik rajzolo -------------------------------------------------
void DrawInvertedStripe_ASM(byte *destptr,dword factor);
#pragma aux DrawInvertedStripe_ASM=                                     \
        "push ebp"                                                      \
        "mov ebp,edi"                                                   \
        "add ebp,229120" /* EBP:= destptr + 4x320x179 */                \
        "mov ecx,90" /* sorok: 178/2 */                                 \
"NxtRow: mov eax,ebx" /* EAX:= factor */                                \
        "and eax,6"                                                     \
        "cmp eax,4"                                                     \
        "ja NoDraw" /* nem kell rajzolni */                             \
        "mov edx,6" /* csik szelessege */                               \
"NxtPix: xor dword ptr [edi + 40 + edx*4],0FFFFFFFFh" /* invertalas: 4x10 */    \
        "xor dword ptr [edi + 1324 + edx*4],0FFFFFFFFh" /* 4x10 + 4x320 + 4 */  \
        "xor dword ptr [ebp + 1192 + edx*4],0FFFFFFFFh" /* 4x298 */             \
        "xor dword ptr [ebp + 2476 + edx*4],0FFFFFFFFh" /* 4x298 + 4x320 + 4 */ \
        "sub edx,2"                                                     \
        "jnz NxtPix"                                                    \
"NoDraw: add edi,2560" /* kovetkezo sor: 4x2x320 */                     \
        "sub ebp,2560"                                                  \
        "dec ebx" /* factor-- */                                        \
        "dec ecx"                                                       \
        "jnz NxtRow"                                                    \
        "pop ebp"                                                       \
        modify [eax ebx ecx edx esi edi]                                \
        parm [edi] [ebx]

void DrawInvertedStripe(byte *destptr,dword factor)
{ DrawInvertedStripe_ASM(destptr,factor);
}

// - kereteltakaro rutin ----------------------------------------------------
void HideBorders_ASM(byte *destptr);
#pragma aux HideBorders_ASM =                                           \
        "xor eax,eax" /* torlo szin */                                  \
        "push edi"                                                      \
        "mov ecx,320" /* felso es also border torlese */                \
"NxtPix: mov dword ptr [edi + 229120],eax" /* 4x179x320 */              \
        "stosd"                                                         \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        "pop edi"                                                       \
        "mov ecx,178" /* oldalso border-ek torlese: */                  \
"NxtRow: add edi,1280" /* 4x320 */                                      \
        "mov dword ptr [edi],eax"                                       \
        "mov dword ptr [edi + 1276],eax" /* 319x4 */                    \
        "dec ecx"                                                       \
        "jnz NxtRow"                                                    \
        modify [eax ebx ecx edx esi edi]                                \
        parm [edi]

void HideBorders(byte *destptr)
{ HideBorders_ASM(destptr);
}
